/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.MenuDialogItem;
import com.aptana.ui.QuickMenuDialog;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class PushToRemoteHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return null;
        }
        String currentBranch = repo.currentBranch();
        ArrayList<MenuDialogItem> remotes = new ArrayList<MenuDialogItem>();
        for (String remote : repo.remotes()) {
            remotes.add(new MenuDialogItem(remote));
        }
        if (!remotes.isEmpty()) {
            QuickMenuDialog dialog = new QuickMenuDialog(this.getShell(), Messages.PushToRemoteHandler_PopupTitle);
            dialog.setInput(remotes);
            if (dialog.open() != -1) {
                MenuDialogItem item = (MenuDialogItem)remotes.get(dialog.getReturnCode());
                PushToRemoteHandler.pushBranchToRemote(repo, currentBranch, item.getText());
            }
        }
        return null;
    }

    public static void pushBranchToRemote(final GitRepository repo, final String branchName, final String remoteName) {
        Job job = new Job(NLS.bind((String)"git push {0} {1}", (Object)remoteName, (Object)branchName)){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return repo.push(new String[]{remoteName, branchName});
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
    }
}

